﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class GlassView : MonoBehaviour
{
    public Transform m_strawberry;//草莓
    public Transform m_lemon;//柠檬
    public Transform m_orange;//橙子
    public Transform m_effectPos;//特效位置
    public Vector3 effectPos => m_effectPos.position;

    private float m_strawberryOffest;
    private float m_lemonOffest;
    private float m_orangeOffest;

    private float m_strawberryNum;
    private float m_lemonNum;
    private float m_orangeNum;

    private float m_strawberryMaxNum = 3.0f;
    private float m_lemonMaxNum = 3.0f;
    private float m_orangeMaxNum = 3.0f;

    private bool m_bControl = true;
    private float m_speed = 2.0f;
    
    //数量
    public void SetFruitNum(int num1,int num2,int num3)
    {
        m_strawberryNum += num1;
        if (m_strawberryNum > m_strawberryMaxNum)
        {
            m_strawberryNum = m_strawberryMaxNum;
        }
        m_lemonNum += num2;
        if(m_lemonNum > m_lemonMaxNum)
        {
            m_lemonNum = m_lemonMaxNum;
        }
        m_orangeNum += num3;
        if(m_orangeNum > m_orangeMaxNum)
        {
            m_orangeNum = m_orangeMaxNum;
        }
    }
    private void Update()
    {
        if (!BattleCtrl.instance.isStartBattle || BattleCtrl.instance.isEndBattle)
        {
            return;
        }
        if (m_strawberryOffest < m_strawberryNum)
        {
            m_strawberryOffest += Time.deltaTime * m_speed;

            Vector3 varSize = m_strawberry.localScale;
            varSize.y = m_strawberryOffest/10.0f;
            m_strawberry.localScale = varSize;

            //柠檬位置
            Vector3 varPos = m_lemon.localPosition;
            varPos.y = m_strawberry.localScale.y / 10.0f + m_strawberry.localScale.y / 60.0f;
            m_lemon.localPosition = varPos;

            //橙子位置
            if(m_orange)
            {
                Vector3 varOrangePos = m_orange.localPosition;
                varOrangePos.y = m_strawberry.localScale.y / 10.0f + m_strawberry.localScale.y / 60.0f
                    + m_lemon.localScale.y / 10.0f + m_lemon.localScale.y / 60.0f;
                m_orange.localPosition = varOrangePos;
            }
        }
        if(m_lemonOffest < m_lemonNum)
        {
            m_lemonOffest += Time.deltaTime * m_speed;

            Vector3 varSize = m_lemon.localScale;
            varSize.y = m_lemonOffest/10.0f;
            m_lemon.localScale = varSize;

            Vector3 varPos = m_lemon.localPosition;
            varPos.y = m_strawberry.localScale.y / 10.0f + m_strawberry.localScale.y / 60.0f;
            m_lemon.localPosition = varPos;

            if (m_orange)
            {
                Vector3 varOrangePos = m_orange.localPosition;
                varOrangePos.y = m_strawberry.localScale.y / 10.0f + m_strawberry.localScale.y / 60.0f
                    + m_lemon.localScale.y / 10.0f + m_lemon.localScale.y / 60.0f;
                m_orange.localPosition = varOrangePos;
            }
        }
        if(m_orangeOffest < m_orangeNum && m_orange)
        {
            m_orangeOffest += Time.deltaTime * m_speed;

            Vector3 varSize = m_orange.localScale;
            varSize.y = m_orangeOffest / 10.0f;
            m_orange.localScale = varSize;

            Vector3 varPos = m_orange.localPosition;
            varPos.y = m_strawberry.localScale.y / 10.0f + m_strawberry.localScale.y / 60.0f
                + m_lemon.localScale.y / 10.0f + m_lemon.localScale.y / 60.0f;
            m_orange.localPosition = varPos;
        }
        if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelOneIndex)
        {
            if (m_strawberryOffest >= m_strawberryMaxNum && m_lemonOffest >= m_lemonMaxNum
                && m_bControl)
            {
                m_bControl = false;
                BattleCtrl.instance.OnBattleWin();
            }
        }
        else if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelTwoIndex
            || BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelThreeIndex)
        {
            if (m_strawberryOffest >= m_strawberryMaxNum && m_lemonOffest >= m_lemonMaxNum
                && m_orangeOffest >= m_orangeMaxNum &&  m_bControl)
            {
                m_bControl = false;
                BattleCtrl.instance.OnBattleWin();
            }
        }
    }
}
